<?php

class NP_hnmSitemakerCS extends NucleusPlugin{
	function getName(){ return 'hnm Site Maker CS'; }// プラグインの名前
	function getAuthor(){ return 'yotaka'; }// プラグインの作者
	function getURL(){ return 'http://hanamachi.com/hnm/'; }//プラグインのサイトURL
	function getVersion(){ return '0.23'; }// プラグインのバージョン
	function getDescription(){ return 'for exclusive use of hnmSite.'; }
	function supportsFeature($what){if($what == 'SqlTablePrefix'){return 1;}else{return 0;}}
	function getEventList(){return array('InitSkinParse','PostSkinParse','PostItem');}
	
	function doSkinVar(){
		global $hnm;
		$r = '';
		$var = func_get_args();
		$skinType = $var[0];
		
		switch($var[1]){
			case 'head':$r = $this -> _hnm_make_head($skinType);break;
			
			case 'adminJS':
			case 'adminAdd':
			case 'adminEdt':
			case 'h1':
			case 'title':$r = $hnm['Sitemaker']['conf'][$var[1]];break;
			
			case 'description':
			case 'Keywords':
				if($hnm['Sitemaker']['conf'][$var[1]]){
					$r = "<meta name='".$var[1]."' content='".$hnm['Sitemaker']['conf'][$var[1]]."' />";
				}
				break;
			
			case 'body':$r = $hnm['Sitemaker']['item']['ibody'];break;
			
			case 'footer':$r = "<div class='fot'>\n".$this -> _hnm_item($var[1])."\n".$hnm['Sitemaker']['conf'][$var[1]]."\n</div>";break;
			
			case 'catCount':$r = 'catc'.$hnm['Sitemaker']['catCount'];break;
			case 'catMenu':$r = $this -> _hnm_make_catmenu();break;
			case 'catNabi':$r = $this -> _hnm_make_catnabi();break;
			
			default:
				$r = $this -> _hnm_item($var[1]);
		}
		if(!$r){
			$r = "<!--hnmSitemaker:".$var[1]."-->";
		}
	echo $r;
	}
	
	function doTemplateVar(){
		echo $var[1];
		global $hnm;
		$r = '';
		$var = func_get_args();
		
		switch($var[1]){
			case 'body':$r = $hnm["Sitemaker"]['item']['ibody'];break;
			case 'adminAdd':$r = $hnm['Sitemaker']['conf']['adminAdd'];break;
			case 'adminEdt':$r = $hnm['Sitemaker']['conf']['adminEdt'];break;
			
			case 'xml':$r = $hnm["Sitemaker"]['item']['xml'][$var[1]][$var[2]];break;
			
			default:
				$r = $this -> _hnm_item($var[1]);
		}
	echo $r;
	}
	

	function doAction($type){
		//引数を定義せず、func_get_args()を用いて取得することも可能です。
		//アクションを実装します。
	}

	function doIf($key, $value){
		//引数を定義せず、func_get_args()を用いて取得することも可能です。
		//プラグイン独自のif拡張を実装します。指定されたパラメータを評価した結果（真偽値）をreturnしてください。
	}
	
	function event_InitSkinParse($data){
		global $DIR_PLUGINS,$DIR_SKINS,$CONF,$member,$itemid,$hnm;
		
		//拡張プラグインを読み込む
		require_once($DIR_PLUGINS.'hnm/hnmPluginCtrl.php');
		
		//拡張機能を読み込み
		$hnm['Sitemaker']['ext'] = HNM_SKIN_CONF::hnm_ext_plugin($DIR_PLUGINS.'hnm/hnmSiteMaker/');
		
		//サイトメーカーのコンフィグ
		$hnm['Sitemaker']['conf'] = HNM_SITEMAKER_CONF::hnm_sitemaker_config();
		if(isset($CONF['hnm']) && $CONF['hnm']){
			$hnm['Sitemaker']['conf'] = $hnm['Sitemaker']['conf'] + $CONF['hnm'];
		}
		
		//設定する
		$this -> _hnm_setting($data["type"]);
		
		//アイテムリスト
		$hnm['Sitemaker']['itemList'] = $this -> _hnm_make_itemList($hnm['Sitemaker']["blogid"]);
		
		//スキンの位置を取得する。
		$sDir = $CONF['SkinsURL'].$data['skin'] -> includePrefix;
		$sPath = $DIR_SKINS.$data['skin'] -> includePrefix;
		$hnm['skin'] = HNM_SITEMAKER_CONF::hnm_sitemaker_skin_config($sDir,$sPath,$hnm['Sitemaker']['blog']["bshortname"]);
		
		//アドミン用のJSを追加
		$hnm['Sitemaker']['conf']['adminJS'] = "<script Language='JavaScript'>\nvar bm = '".$CONF['AdminURL']."bookmarklet.php';\n</script>\n";
		//アドミン用のリンクを追加
		$this -> _hnm_kanri_link();
		
		$this -> _hnm_make_desc();//詳細を設定
		$this -> _hnm_make_keys();//キーワードを設定
		$this -> _hnm_make_title();//表題を作成する
		
		switch($hnm["request"]['c']){
			case 'h':var_dump($hnm);break;
			case 's':var_dump($hnm['Sitemaker']);break;
			case 'c':var_dump($hnm['Sitemaker']['conf']);break;
			case 'l':var_dump($hnm['Sitemaker']['itemList']);break;
		}
	}
	
	function event_PostSkinParse($data){
		//スキンのパースの直前に呼ばれます。
		/* 引数構造
		$data => 
			'skin' => & パースするSKINオブジェクト
			'type' => スキンタイプ（'index', 'item', 'archive', 'archivelist', 'member', 'error', 'search', 'imagepopup', 'fileparser'など）
		*/
	}

	function event_PostItem($data){
		//アイテムのパース後、アイテムフッターのパース前に呼ばれます。
		/* 引数構造
		$data => 
			'blog' => & BLOG オブジェクト
			'item' => & アイテムデータを持つオブジェクト
		*/
	}
	
	
	private function _hnm_setting($type){//設定ファンクション
		global $hnm,$blogid,$catid,$hnmLib;
		
		//リクエストを挿入
		$hnm['request'] = $hnmLib -> hnm_request();
		
		//個別アイテムの場合はアイテムデータを取得：これでスペシャルスキンでも有効になります。
		if($hnm['request']['itemid']){
			global $itemid;
			$itemid = $hnm['request']['itemid'];
			$hnm['Sitemaker']['item'] = $this -> _hnm_itemget($itemid);
			$catid = $hnm['Sitemaker']['item']['icat'];
			$blogid = $hnm['Sitemaker']['item']['iblog'];
			$hnm['Sitemaker']["conf"]['ptype'] = 'pge';
		}
		
		//ブログデータを取得する
		$hnm['Sitemaker']['blog'] = $this -> _hnm_blogget($blogid);
		$hnm['Sitemaker']['blogid'] = $blogid;
		//ブログショートネームからブログタイプを取得
		$btype = $hnmLib -> hnm_endstr($hnm['Sitemaker']['blog']['bshortname'],2);
		
		//サポートサイトデータを取得する
		$hnm['Sitemaker']["conf"]['btype'] = 'Std';
		switch($btype){
			case $hnm['Sitemaker']["conf"]['Pg']:
				$hnm['Sitemaker']["conf"]['btype'] = $hnm['Sitemaker']["conf"]['Pg'];
				break;
			
			case $hnm['Sitemaker']["conf"]['Dm']:
				$hnm['Sitemaker']["conf"]['btype'] = $hnm['Sitemaker']["conf"]['Dm'];
			
			default:
				$hnm['Sitemaker']['blogPg'] = $this -> _hnm_blogget_name($hnm['Sitemaker']['blog']['bshortname'].$hnm['Sitemaker']["conf"]['Pg']);
				$hnm['Sitemaker']['blogPgid'] = $hnm['Sitemaker']['blogPg']['bnumber'];
		}
		
		//カテゴリデータを取得する
		$hnm['Sitemaker']['cat'] = $this -> _hnm_catget($blogid);
		$this -> _hnm_catset();
		
		if($catid){
			$hnm['Sitemaker']['catid'] = $catid ;
			if(!$hnm['Sitemaker']["conf"]['ptype']){
				$hnm['Sitemaker']["conf"]['ptype'] = 'ctp';
			}
		}else{
			$hnm['Sitemaker']['catid'] = $catid = '0';
			$hnm['Sitemaker']["conf"]['ptype'] = 'top';
		}

		//サポートページでないトップページであれば
		if($type == 'index'){
			//カテゴリ名を準備する
			$cat_name = 'c'.$hnm['Sitemaker']['catid'];
			
		//サポートブログであれば、自分のブログのIDを設定する
			if($hnm['Sitemaker']['conf']['btype'] == "Pg"){
				$blogid = $hnm['Sitemaker']['blogid'];
				
			}else{//サポートブログで無ければ、サポートブログのIDを設定する
				$blogid = $hnm['Sitemaker']['blogPgid'];
			}
			$hnm['Sitemaker']['item'] = $this -> _hnm_itemget_name($cat_name,$blogid);
		}
		
		if(isset($hnm['Sitemaker']['item']["ibody"]) && $hnm['Sitemaker']['item']["ibody"]){//本文データを編集
			$hnm['Sitemaker']['item']["ibody"] = $this -> _hnm_make_body($hnm['Sitemaker']['item']["ibody"]);
		}
		if(isset($hnm['Sitemaker']['item']["imore"]) && $hnm['Sitemaker']['item']["imore"]){//モアデータを編集
			$hnm['Sitemaker']['item']["xml"] = $hnmLib -> _xml_array($hnm['Sitemaker']['item']["imore"]);
		}
	}
	
	private function _hnm_make_itemmenu($list,$tag = 'ul',$class=''){
		$r = '';
		if($list){
			$list = implode("</li>\n<li>",$list);
			if($class){$class=' class="'.$class.'"';}
			$list = "<".$tag.$class.">\n<li>".$list."</li>\n</".$tag.">\n";
		$r = $list;
		}
	return $r;
	}
	
	private function _hnm_make_itemList($blogid){
		if($blogid){
			$r = $link = array();
			$list = $this -> _hnm_itemget_list($blogid);
			for($i=0; $i<count($list); $i++){
				$r[$list[$i]['icat']][$i]['id'] = $list[$i]['inumber'];
				$r[$list[$i]['icat']][$i]['title'] = $list[$i]['ititle'];
				$link[$list[$i]['icat']][$i] = "<a href = ".$this -> _hnm_make_href($list[$i]['inumber']).">".$list[$i]['ititle']."</a>";
			}
		}
		$r['link'] = $link;
	return $r;
	}
	
	private function _hnm_make_catmenu(){//アサイドメニューのカテゴリリスト
		global $hnm;
		$r = array();
		
		//ホームの追加
		if(isset($hnm['Sitemaker']['conf']["homeMenu"]) && $hnm['Sitemaker']['conf']["homeMenu"] != 'non'){
			array_push($r,"<dt><a href=".$this -> _hnm_make_href('', '', $hnm['Sitemaker']["blogid"]).">".$hnm['Sitemaker']['conf']["homeMenu"]."</a></dt>");
		}
		
		$blogid = $hnm['Sitemaker']["blogid"];
		$catid = $hnm['Sitemaker']["catid"];
		
		for($i=0; $i<count($hnm['Sitemaker']['cat']); $i++){
			$cid = $hnm['Sitemaker']['cat'][$i]["catid"];
			if($catid == $cid){$cls = 'yes';}else{$cls = 'no';}//アサイドのアイテムオープンを調整します。
			
			array_push($r,"<dd class='catbut ".$cls."'>".'<a href="'.$this -> _hnm_make_href("", $cid, $blogid).'">'.$hnm['Sitemaker']['cat'][$i]["cname"].'</a></dd>');
			$dd_item = $this -> _hnm_make_itemmenu($hnm['Sitemaker']["itemList"]["link"][$cid],'ul');
			if($dd_item){
				$dd_item = "<dd class='itembut ".$cls."'>\n".$dd_item."</dd>\n";
				array_push($r,$dd_item);
			}
		}
		$r = implode("\n",$r);
	return "<dl class='categorylist'>\n".$r."\n</dl>\n";
	}
	
	private function _hnm_make_catnabi(){//グローバルメニューのカテゴリリスト
		global $hnm;
		$r = array();
		
		//ホームの追加
		if(isset($hnm['Sitemaker']['conf']["homeMenu"]) && $hnm['Sitemaker']['conf']["homeMenu"] != 'non'){
			array_push($r,"<dt><a href=".$this -> _hnm_make_href('', '', $hnm['Sitemaker']["blogid"]).">".$hnm['Sitemaker']['conf']["homeMenu"]."</a></dt>");
		}else{
			array_push($r,"<dt><a href=".$this -> _hnm_make_href('', '', $hnm['Sitemaker']["blogid"]).">ホーム</a></dt>");
		}
		
		$blogid = $hnm['Sitemaker']["blogid"];
		$catid = $hnm['Sitemaker']["catid"];
		
		for($i=0; $i<count($hnm['Sitemaker']['cat']); $i++){
			$cid = $hnm['Sitemaker']['cat'][$i]["catid"];
			if($catid == $cid){$cls = 'yes';}else{$cls = 'no';}
			array_push($r,"<dd class='catbut ".$cls."'>".'<a href="'.$this -> _hnm_make_href("", $cid, $blogid).'">'.$hnm['Sitemaker']['cat'][$i]["cname"].'</a></dd>');
		}
	return implode("\n",$r);
	}
	
	private function _hnm_catset(){//カテゴリの各種設定
		global $hnm;
		$hnm['Sitemaker']['catlist'] = array();
		$hnm['Sitemaker']['catCount'] = $ccount = count($hnm['Sitemaker']['cat']);
		
		for($i=0; $i<$ccount; $i++){
			$hnm['Sitemaker']['catlist'][$hnm['Sitemaker']['cat'][$i]['catid']] = $i;//逆引きのデータを準備する
			//カテゴリ名で操作をするならここに挿入する。
			$hnm['Sitemaker']['cat'][$i]['cname'] = preg_replace('#<!--(.*?)-->#s','',$hnm['Sitemaker']['cat'][$i]['cname']);
		}
	}
	
	private function _hnm_make_body($body){//ボディー部分のインクルード、イメージを処理。
		$body = preg_replace_callback('#<%hnm\((.*?)\)%>#s',array(&$this,'_hnm_includeitem'),$body);
		$body = preg_replace_callback('#<%(image|popup|ipopup|hnm)\((.*?)\)%>#s',array(&$this,'_hnm_includeimg'),$body);
		$body = $this -> _addbreak($body);
	return $body;
	}
	
	private function _hnm_make_head($skinType){//ヘッダーデータ作成
		global $hnm,$hnmLib;
		$r = array();
		
		//ブログタイプの設定
		switch($hnm["Sitemaker"]["conf"]["btype"]){
			case $hnm['Sitemaker']["conf"]['Pg']://サポートブログ
				$hnm['skin']['css']['base'] = $hnm['skin']['css']['sub'] = $hnm['skin']['css']['ext'] = $hnm['skin']['css']['ie6'] = '';
				break;
				
			default://通常ブログ
				$hnm['skin']['css']['edit'] = '';
		}
		
		array_push($r, $this -> _hnm_head_css_get($skinType));//CSSファイルを設定
		array_push($r, $this -> _hnm_head_js_get($skinType));//JSファイルを設定
		
	return implode("\n",$r);
	}
	
	
	private function _hnm_make_title(){//タイトルと見出しの作成
		global $hnm;
		$desc = $hnm['Sitemaker']['conf']['description'];
		
		switch($hnm['Sitemaker']['conf']['ptype']){
			case 'top':$title = $hnm['Sitemaker']['blog']['bname'];break;
			case 'ctp':$title = $hnm['Sitemaker']['cat'][$hnm['Sitemaker']['catlist'][$hnm['Sitemaker']['catid']]]['cname'];break;
			case 'pge':$title = $hnm['Sitemaker']['item']['ititle'];break;
		}
		
		$hnm['Sitemaker']['conf']['h1'] = $hnm['Sitemaker']['conf']['title'] = $title;
		if($desc){
			$hnm['Sitemaker']['conf']['h1'].= '<span class="small">：'.$desc."</span>";
			$hnm['Sitemaker']['conf']['title'] = $desc.'：'.$hnm['Sitemaker']['conf']['title'];
		}
		$hnm['Sitemaker']['conf']['title'] = '<title>'.$hnm['Sitemaker']['conf']['title']."</title>\n";
	}
	
	
	private function _hnm_make_desc(){//サイトの詳細
		global $hnm;
		$r = '';
		$catid = $hnm['Sitemaker']["catid"];
		
		if($hnm['Sitemaker']['item']['xml']["desc"]["value"]){//アイテムの詳細を代入
			$r = $hnm['Sitemaker']['item']['xml']["desc"]["value"];}
			
		elseif($hnm['Sitemaker']['cat'][$hnm['Sitemaker']["catlist"][$catid]]["cdesc"]){//カテゴリの詳細を代入
			$r = $hnm['Sitemaker']['cat'][$hnm['Sitemaker']["catlist"][$catid]]["cdesc"];}
			
		else{$r = $hnm['Sitemaker']["blog"]["bdesc"];}//サイトの詳細を流用
		
		if($r){$hnm['Sitemaker']['conf']['description'] = $r;}
	}
	
	
	private function _hnm_make_keys(){//サイトキーワード
		global $hnm;
		$r = '';
		
		if($hnm['Sitemaker']['item']['xml']["key"]["value"]){//アイテムの詳細を代入
			$r = $hnm['Sitemaker']['item']['xml']["key"]["value"];}
		
		if($r){$hnm['Sitemaker']['conf']['Keywords'] = $r;}
	}
	
	private function _hnm_head_css_get($skinType){//CSSファイルを埋め込む
		global $hnm, $hnmLib;
		$r = array();
		
		//top.cssを設定する
		if($skinType == 'index' && $hnm["Sitemaker"]["catid"] == 0 && $hnm["Sitemaker"]["conf"]["btype"] != $hnm['Sitemaker']["conf"]['Pg']){
			$hnm['skin']['css']['sub'][0] = $hnm['skin']['css']['sub'][2];
			$hnm['skin']['css']['sub'][2] = '';
		}
		
		$keys = array_keys($hnm['skin']['css']);
		foreach($keys as $k){
			$css = $hnmLib -> hnm_file_set($hnm['skin']["skinPath"],$hnm['skin']["skinDir"],$hnm['skin']['css'][$k]);
			if($css){
				if($k == 'ie6'){array_push($r , '<!--[if IE 5.5000 | IE 6]><link rel="stylesheet" type="text/css" href="'.$css.'" /><![endif]-->');}
				else{array_push($r , '<link rel="stylesheet" type="text/css" href="'.$css.'" />');}
			}
		}
	return implode("\n",$r);
	}

	private function _hnm_head_js_get($skinType){//JSファイルを埋め込む
		global $hnm, $hnmLib;
		$r = array();
		$keys = array_keys($hnm['skin']['js']);
		foreach($keys as $k){
			$js = $hnmLib -> hnm_file_set($hnm['skin']["skinPath"],$hnm['skin']["skinDir"],$hnm['skin']['js'][$k]);
			if($js){
				array_push($r , '<script type="text/javascript" src="'.$js.'"></script>');
			}
		}
	return implode("\n",$r);
	}

	private function _hnm_includeimg($match){//アイテム中の画像などを表示させます。
		global $hnm,$CONF,$DIR_MEDIA;
		$author = $hnm['Sitemaker']['item']['iauthor'];
		$tmp = explode("|",$match[2]);//通常の画像用のタグとして処理
		$chk = explode("/",$tmp[0]);//ディリクトリを取得

		switch($match[1]){
			case 'image':
				if($chk[1]){//ファイルのパスとURLをチェック
					$imgSize = $DIR_MEDIA.implode('/',$chk);
					$tmp[0] = $CONF["MediaURL"].$tmp[0];
					
				}else{
					$imgSize = $DIR_MEDIA.$author."/".$tmp[0];
					$tmp[0] = $CONF["MediaURL"].$author."/".$tmp[0];
				}
				
				if(!file_exists($imgSize)){break;}//ファイルのチェック
				
				if($tmp[4]){$tmp[4].= " ";}
				$imgSize = getimagesize($imgSize);
				if($imgSize[0]>$imgSize[1]){$tmp[4].= 'xBot';}
				elseif($imgSize[0]<$imgSize[1]){$tmp[4].= 'yBot';}
				else{$tmp[4].= 'sBot';}
				$res = "<img src='".$tmp[0]."' alt='".$tmp[3]."' class='".$tmp[4]."' />\n";
		break ;
				
			case 'popup':
				if(!$chk[1]){$tmp[0] = $author."/".$tmp[0];}
				$res = "<a href=\"index.php?imagepopup=".$tmp[0];
				$res.= "&amp;width=".$tmp[1]."&amp;height=".$tmp[2]."&amp;imagetext=".$tmp[3]."\" ";
				$res.= "onclick=\"window.open(this.href,'imagepopup','status=no,toolbar=no,scrollbars=no,resizable=yes,";
				$res.= "width=".$tmp[1].",height=".$tmp[2]."');return false;\">";
				$res.= $tmp[3]."</a>\n";
		break ;
				
			case 'ipopup'://イメージボタンをつかったポップアップを作成します。まだ考え中
//				if(!$chk[1]){$tmp[0] = $author."/".$tmp[0];}
//				$res = "<a href=\"index.php?imagepopup=".$tmp[0];
//				$res.= "&amp;width=".$tmp[1]."&amp;height=".$tmp[2]."&amp;imagetext=".$tmp[3]."\" ";
//				$res.= "onclick=\"window.open(this.href,'imagepopup','status=no,toolbar=no,scrollbars=no,resizable=yes,";
//				$res.= "width=".$tmp[1].",height=".$tmp[2]."');return false;\">";
//				$res.= $tmp[3]."</a>\n";
		break ;
			
			case 'hnm':
				$res = "<!--hnm:".$match[2]."-->\n";
		break;
		}
	return $res ;
	}

	private function _hnm_includeitem($match){//アイテム中に他のアイテムを埋め込みます。
		global $hnm,$hnmLib;
		$r = array();
		$tmpl = array('xml','plist','list','tbl','txt','name');//レイアウト用コマンド
		$items = explode(",",$match[1]);//取得アイテムを分割する
		$com = explode('-',$items[0]);//コマンドを確認する
		
		if(in_array($com[0],$tmpl)){//テンプレートが指定されている場合は、moreを編集する
			$items[0] = '';
			$items = $hnmLib -> hnm_array_noblank($items);
			
			if(is_numeric($items[1])){//番号で検索する
				$res = $this -> _hnm_itemget($items);
				
			}else{//タイトル名で検索する
				if($hnm['Sitemaker']['conf']['btype'] == "Pg"){$blogid = $hnm['Sitemaker']['blogid'];}
				else{$blogid = $hnm['Sitemaker']['blogPgid'];}
				$res = $this -> _hnm_itemget_name($items,$blogid);
			}
			
			foreach($res as $row){
				//ここにテンプレートを適応するファンクションを追加します。
				array_push($r,$row['imore']);
			}
			
		}else{//テンプレートが指定されてない場合は、bodyを列記する
			if(is_numeric($items[0])){//番号で検索する
				$res = $this -> _hnm_itemget($items);
		
			}else{//タイトル名で検索する
				if($hnm['Sitemaker']['conf']['btype'] == "Pg"){$blogid = $hnm['Sitemaker']['blogid'];}
				else{$blogid = $hnm['Sitemaker']['blogPgid'];}
				$res = $this -> _hnm_itemget_name($items,$blogid);
			}
			foreach($res as $row){
				array_push($r,$row['ibody']);
			}
		}
	return implode("\n",$r);
	}
	
	//ヤマさんの作ってくれた改行置換えファンクション
	private function _addbreak($text){
		global $hnmLib;
	return $hnmLib -> addbreak($text);
	}
	
	//リンク切替用ファンクション：アンカー内にクラスを指定する場合があるので、hrefのみを記述
	private function _hnm_make_href($i="", $c="", $b="", $ref=""){
		global $hnm;
		
		//データがない場合は、代入する
		if($i && !$b){$b = $hnm['Sitemaker']["blogid"];}
		if($i && !$c){$c = $hnm['Sitemaker']["catid"];}
		
		if($b){$href[1][0]="b".$b;$href[0][0]="blogid=".$b;}
		if($c){$href[1][1]="c".$c;$href[0][1]="catid=".$c;}
		if($i){$href[1][2]="i".$i;$href[0][2]="itemid=".$i;}
		if($ref){$href[1][3]="r".$ref;$href[0][3]="refid=".$ref;}
		
		$href[0] = implode('&amp;',$href[0]);
		$href[1] = implode('',$href[1]).".html";
		
		if($hnm['Sitemaker']['conf']["link"] == 'short'){
			$res = "./".$href[1];
			
		}else{
			$res = explode('?',$hnm['Sitemaker']['blog']["burl"]);
			$res = $res[0]."?".$href[0];
		}
		
	return $res ;
	}
	
	//管理用、編集リンク、新規作成リンク
	private function _hnm_kanri_link(){
		global $hnm;
		
		$add[0] = $edt[0] = '<a href="'.$_SERVER["REQUEST_URI"].'#" onclick="hnmMado(bm,'."'";
		$add[1] = $edt[1] = '';
		$add[2] = $edt[2] = "'".');">';
		$add[3] = '新規ページ作成';
		$edt[3] = 'このページを編集';
		$add[4] = $edt[4] = '</a>';
		
		$addUrl = '?blogid=';
		$addtitle = '&amp;loglinktitle=c';
		$editUrl = '?action=edit&amp;itemid=';
		
		$blogid = $hnm['Sitemaker']['blogid'];
		$catid = $hnm['Sitemaker']['catid'];
		
		if($hnm['Sitemaker']['item']['ititle']){
			$ptype = $hnm['Sitemaker']['conf']['ptype'].'_1';
			$itemid = $hnm['Sitemaker']['item']["inumber"];
		}else{
			$ptype = $hnm['Sitemaker']['conf']['ptype'].'_0';
		}
		
		switch($ptype){
			case 'top_0':
			case 'ctp_0':
			$add[1] = $addUrl.$blogid;
			$edt[1] = $addUrl.$blogid.$addtitle.$catid;
		break;
		
			case 'top_1':
			case 'ctp_1':
			$add[1] = $addUrl.$blogid;
			$edt[1] = $editUrl.$itemid;
		break;
		
			case 'pge_0':
			case 'pge_1':
			$add[1] = $addUrl.$blogid;
			$edt[1] = $editUrl.$itemid;
		break;
			default:
		}
		
		$hnm['Sitemaker']['conf']['adminAdd'] = implode('',$add);
		$hnm['Sitemaker']['conf']['adminEdt'] = implode('',$edt);
		
		if($hnm['Sitemaker']['conf']['btype'] == 'Pg' && $catid == '0'){
			$hnm['Sitemaker']['conf']['adminEdt'] = '';
		}
	}
	
	private function _hnm_item($name){//DBからアイテム名でデータ取得
		global $hnm;
		if($hnm['Sitemaker']['conf']['btype'] == "Pg"){$blogid = $hnm['Sitemaker']['blogid'];}
		else{$blogid = $hnm['Sitemaker']['blogPgid'];}
		$r = $this -> _hnm_itemget_name($name,$blogid);
	return $r["ibody"];
	}
	
/* ==============================
	SQL接続
============================== */
	private function _hnm_itemget($itemid){//アイテムIDからアイテムデータを取得する
		if(is_array($itemid)){
			$itemid = implode(",",$itemid);
			$result = "SELECT * FROM `".sql_table('item')."` WHERE `idraft` !=1 AND `inumber` IN (".$itemid.")";
			$result = $this -> _hnm_sql_query_row($result);
		}else{
			$result = "SELECT * FROM `".sql_table('item')."` WHERE `idraft` !=1 AND `inumber`=".$itemid;
			$result = $this -> _hnm_sql_query($result);
		}
	return $result;
	}
	
	private function _hnm_itemget_name($ititle,$iblog){//アイテム名からアイテムデータを取得する
		//キャッシュを保存する場合の分岐はココで設定します。
		if(is_array($ititle)){
			$ititle = implode("','",$ititle);
			$result = "SELECT * FROM `".sql_table('item')."` WHERE `ititle` IN ('".$ititle."') AND `iblog`= ".$iblog;
			$result = $this -> _hnm_sql_query_row($result);
		}else{
			$result = "SELECT * FROM `".sql_table('item')."` WHERE `ititle`='".$ititle."' AND `iblog`= ".$iblog.$limit." LIMIT 0,1";
			$result = $this -> _hnm_sql_query($result);
		}
	return $result;
	}
	
	private function _hnm_itemget_list($blogid,$start = 0,$end = 20){//アイテムIDを取得してリストを作成する
		$result = "SELECT `inumber` , `ititle`  , `icat` FROM  `".sql_table('item')."` WHERE `idraft` !=1 AND `iblog` =".$blogid." ORDER BY  `itime` DESC LIMIT ".$start." , ".$end;
		$result = $this -> _hnm_sql_query_row($result);
	return $result;
	}
	
	private function _hnm_catget($blogid){//カテゴリデータを取得する
		$result = "SELECT * FROM `".sql_table('category')."` WHERE `cblog`=".$blogid." ORDER BY `cname` ASC";
		$result = $this -> _hnm_sql_query_row($result);
	return $result;
	}
	
	private function _hnm_blogget($blogid){//ブログデータを取得する
		$result = "SELECT * FROM `".sql_table('blog')."` WHERE `bnumber`=".$blogid;
		$result = $this -> _hnm_sql_query($result);
	return $result;
	}
	
	private function _hnm_blogget_name($bshortname){//省略名からブログデータを取得する
		$result = "SELECT * FROM `".sql_table('blog')."` WHERE `bshortname`='".$bshortname."'";
		$result = $this -> _hnm_sql_query($result);
	return $result;
	}

	private function _hnm_sql_query($result){//配列を取得する
		$result = sql_query($result);
		$result = mysql_fetch_array($result, MYSQL_ASSOC);
	return $result;
	}

	private function _hnm_sql_query_row($result){//多重配列のデータを取得する
		$i = 0;
		$result = sql_query($result);
		while($row = mysql_fetch_array($result, MYSQL_ASSOC)){
			$r[$i] = $row;
			$i++;
		}
	return $r;
	}
}
?>